
package edu.unl.consystlab.sudoku;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;

import javax.swing.JMenu;
import javax.swing.JMenuItem;


public class PuzzleMenu extends JMenu implements ActionListener
{
	private List puzzles;
	private Game game;

	public PuzzleMenu(Game game)
	{
		super("Puzzles");
		this.game = game;
		puzzles = Puzzles.getPuzzles();
		Iterator i = puzzles.iterator();
		while (i.hasNext())
		{
			Puzzle p = (Puzzle)i.next();
			JMenuItem jm = new JMenuItem(p.getName());
			jm.setActionCommand(p.getName());
			jm.addActionListener(this);
			this.add(jm);
		}
	} // constructor

	public void actionPerformed(ActionEvent event)
	{
		//Debug.debug("PuzzleMenu.actionPerformed()");
		Object o = event.getSource();
		if (o instanceof JMenuItem)
		{
			JMenuItem jm = (JMenuItem)o;
			//Debug.debug("PuzzleMenu.actionPerformed(): puzzle="+
			//	jm.getActionCommand());
			setPuzzle(jm.getActionCommand());
		}
	} // actionPerformed();

	public void setPuzzle(String name)
	{
		Iterator i = puzzles.iterator();
		while (i.hasNext())
		{
			Puzzle p = (Puzzle)i.next();
			if(!p.getName().equals(name))
				continue;
			{
				game.inform("Using "+p.getName()+
					"("+p.getDescription()+")");
				//Debug.debug("setting puzzle "+p.getName());
				p.fillGrid(game.getGrid());
			}
		}
	}  // setPuzzle

}
